
if not exists (SELECT * FROM INFORMATION_SCHEMA.COLUMNS
							where table_name = 'TENTACLE_SYNC_TABELAS' and column_name ='TP_CONTROLE')
begin
	ALTER TABLE TENTACLE_SYNC_TABELAS ADD TP_CONTROLE TINYINT NOT NULL DEFAULT(0);
end

go

	UPDATE TENTACLE_SYNC_TABELAS
	SET
		TP_CONTROLE=1
	where 
		TABELA_ORIGEM_MONITORADA='EST_PROD_CPL'
		AND TP_CONTROLE=0;
GO

/*****************************************************************************************************************************/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_TENTACLE_SYNC_TABELAS_CARGA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_TENTACLE_SYNC_TABELAS_CARGA]
GO
GO
CREATE PROCEDURE P_TENTACLE_SYNC_TABELAS_CARGA (@MainTable Varchar(100), @Atualizar tinyint=0)
AS

	SET NOCOUNT ON;
	Declare @Cmd varchar(max)
	Declare @Coluna varchar(100)
	Declare @sColunas Varchar(800)
 
	DECLARE @Tabela VARCHAR(100) =@MainTable+'_CARGA';

	IF @MainTable IS NULL
	RETURN;

	UPDATE TENTACLE_SYNC_TABELAS
	SET
		TP_CONTROLE=1
	where 
		TABELA_ORIGEM_MONITORADA=@MainTable
		AND TP_CONTROLE=0;


	IF Exists (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = @MainTable)
	BEGIN
		if @Atualizar=1
		begin
			SET		@Cmd = 'BEGIN TRY drop table '+@Tabela +' END TRY BEGIN CATCH END CATCH;;'
			EXEC(@Cmd);
		END
		ELSE
		BEGIN
			RETURN;
		END
	end
 
  
/***************************************************************************************************************************************/     
-- Criao da tabela padrao
/***************************************************************************************************************************************/     

SET @Cmd = 'CREATE TABLE [DBO].['+@Tabela+'](
		[CD_CTR_CARGA] [INT] IDENTITY(1,1) NOT NULL,
		[TP_REG] [TINYINT] NULL,
		[DT_HR] [DATETIME] NULL,
		[VERSAO]  INT DEFAULT  datediff(second, ''1970-01-01T00:00:00'', GETDATE()),
	 CONSTRAINT [PK_'+@Tabela+'] PRIMARY KEY CLUSTERED 
		([CD_CTR_CARGA] ASC)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]'
	
Exec( @Cmd); 			

/***************************************************************************************************************************************/     
-- Criao das colunas da chave primaria
/***************************************************************************************************************************************/     
set @sColunas ='';

declare c_Chave CURSOR FAST_FORWARD FOR
SELECT 
	C.NAME
FROM 
	SYS.INDEXES i
	join SYS.SYSINDEXKEYS  k on 
	i.index_id = k.indid and
	i.object_id = k.id
	join sys.columns c on 
	k.colid = c.column_id and
	k.id	= c.object_id 
where
	i.object_id=object_id (@MainTable)
	and is_unique =1
	and is_primary_key =1  

OPEN c_Chave
FETCH NEXT FROM c_Chave INTO @Coluna
WHILE @@FETCH_STATUS = 0
	BEGIN
	 
		SELECT @Cmd = 'ALTER TABLE ['+@Tabela+'] ADD ' + @COLUNA + ' ' + DATA_TYPE  FROM INFORMATION_SCHEMA.COLUMNS   WHERE TABLE_NAME=@MainTable  AND COLUMN_NAME=@Coluna
		 Set @sColunas= @sColunas + @Coluna + ','
		Exec(@Cmd);
		FETCH NEXT FROM c_Chave INTO @Coluna
	END
CLOSE c_Chave;
DEALLOCATE c_Chave; 

/***************************************************************************************************************************************/     
-- Criao dos indexes
/***************************************************************************************************************************************/     
Set @Cmd = 'BEGIN TRY 
CREATE NONCLUSTERED INDEX IX_'+@Tabela+'_VERSAO ON ' +@Tabela+' 
	(VERSAO) WITH (FILLFACTOR=97);
END TRY 
BEGIN CATCH
	 Print ''Nao criou index ''
END CATCH';
Exec (@Cmd);

if Exists(select * from information_schema.COLUMNS WHERE TABLE_NAME=@MainTable  AND COLUMN_NAME='CD_FILIAL')
BEGIN
	Set @Cmd = 'BEGIN TRY 
		CREATE NONCLUSTERED INDEX IX_'+@Tabela+'_VERSAO_FILIAL ON '+@Tabela+'
			(VERSAO,CD_FILIAL) WITH (FILLFACTOR=97);
	END TRY 
	BEGIN CATCH
		 Print ''Nao criou index ''
	END CATCH';
	
	Exec (@Cmd);
END

/***************************************************************************************************************************************/      
--
/***************************************************************************************************************************************/

Set @Cmd='IF EXISTS( SELECT * FROM SYS.OBJECTS WHERE NAME = ''TRG_' +@TABELA + ''' AND TYPE = ''TR'')
BEGIN
	DROP TRIGGER dbo.TRG_'+@TABELA +'
END ';
Exec (@Cmd); 

Set @Cmd='CREATE TRIGGER [dbo].[TRG_'+@Tabela+'] ON [dbo].['+@MainTable+'] 
FOR 
	INSERT, UPDATE, DELETE
AS 
SET NOCOUNT ON
DECLARE @tpReg as tinyint=2;

if Exists(select * from Inserted)
	Set @tpReg =0;

if Exists(select * from Deleted)
	if @tpReg =0
		Set @tpReg =1;		
if @tpReg =2
	begin
		INSERT INTO	'+@Tabela+' (' + @sColunas+' TP_REG,DT_HR)
		SELECT '+@sColunas+' @tpReg TP_REG, GETDATE() DT_HR
		FROM DELETED
	END
else
	BEGIN	
		INSERT INTO '+@Tabela+' (' + @sColunas+' TP_REG,DT_HR)
		SELECT '  + @sColunas+' @tpReg TP_REG ,GETDATE() DT_HR
		FROM INSERTED
	END'
Exec (@Cmd);;